/////////////////////////////////////////////////////////////
// CINEMA SDK : OPERATORS      														 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_OPERATORPLUGIN_H
#define __C4D_OPERATORPLUGIN_H

////////////////////////////////

#include "ge_math.h"
#include "c4d_operatordata.h"
#include "c4d_nodeplugin.h"

////////////////////////////////

struct OPERATORPLUGIN : public NODEPLUGIN
{
	LONG					op_group;
	LONG					op_class;
	LONG					op_owner;

	Bool					(GvOperatorData::*iCreateOperator							)(GvNode *bn);
	const String	(GvOperatorData::*GetDetailedText							)(GvNode *bn);
	const String	(GvOperatorData::*GetText											)(GvNode *bn);
	const String	(GvOperatorData::*GetTitle										)(GvNode *bn);
	BaseBitmap*		(GvOperatorData::*GetPortIcon									)(GvNode *bn, LONG id, GvLayoutType layout_type);
	void					(GvOperatorData::*GetBodySize									)(GvNode *bn, LONG *width, LONG *height);
	const Vector	(GvOperatorData::*GetBodyColor								)(GvNode *bn);
	void					(GvOperatorData::*EditorDraw									)(GvNode *bn, GvNodeGUI* gui, GeUserArea *da, LONG x1, LONG y1, LONG x2, LONG y2);
	void					(GvOperatorData::*iGetPortList								)(GvNode *bn, GvPortIO port, GvPortList &portlist);
	Bool					(GvOperatorData::*iGetPortDescription					)(GvNode *bn, GvPortIO port, LONG id, GvPortDescription *pd);
	Bool					(GvOperatorData::*GetOperatorDescription			)(GvNode *bn, GvOperatorDescription *od);
	Bool					(GvOperatorData::*QueryCalculation						)(GvNode *bn, GvQuery *query);
	Bool					(GvOperatorData::*InitCalculation							)(GvNode *bn, GvCalc *calc, GvRun *run);
	void					(GvOperatorData::*FreeCalculation							)(GvNode *bn, GvCalc *calc);
	Bool					(GvOperatorData::*Calculate										)(GvNode *bn, GvPort *port, GvRun *run, GvCalc *calc);
	Bool					(GvOperatorData::*AddToCalculationTable				)(GvNode *bn, GvRun *run); 
	Bool					(GvOperatorData::*SetRecalculate							)(GvNode *bn, GvPort *port, GvRun *run, Bool force_set);
	Bool					(GvOperatorData::*SetData											)(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode);
	Bool					(GvOperatorData::*IsSetDataAllowed						)(GvNode *bn, GvDataType type, void *data, GvOpSetDataMode mode);
	LONG					(GvOperatorData::*FillPortMenu								)(GvNode *bn, BaseContainer &menu, LONG port_id, LONG first_menu_id);
	Bool					(GvOperatorData::*PortMenuCommand							)(GvNode *bn, LONG menu_id, LONG port_id, LONG mx, LONG my);
	LONG					(GvOperatorData::*FillOperatorMenu						)(GvNode *bn, BaseContainer &menu, LONG first_menu_id);
	Bool					(GvOperatorData::*OperatorMenuCommand					)(GvNode *bn, LONG menu_id, LONG mx, LONG my);
	LONG					(GvOperatorData::*FillPortsMenu								)(GvNode *bn, BaseContainer &names, BaseContainer &ids, GvValueID value_type, GvPortIO port, LONG first_menu_id);
	Bool					(GvOperatorData::*BodyMessage									)(GvNode *bn, GvNodeGUI *gui, LONG x, LONG y, LONG chn, LONG qua, const BaseContainer &msg);
	Bool					(GvOperatorData::*EditSettings								)(GvNode *bn, GvNodeGUI *gui);
	const String  (GvOperatorData::*GetErrorString							)(GvNode *bn, LONG error);
	Bool					(GvOperatorData::*SceneDraw										)(GvNode *bn, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt, LONG flags, void *data, ULONG counter);
	LONG					(GvOperatorData::*GetMainID										)(GvNode *bn, GvPortIO io, const DescID &desc_id);
	const DescID	(GvOperatorData::*GetDescID										)(GvNode *bn, GvPortIO io, LONG main_id);
	Bool					(GvOperatorData::*CreatePortDescriptionCache	)(GvNode *bn, Bool lock_only);
	void					(GvOperatorData::*FreePortDescriptionCache		)(GvNode *bn);

	void*	reserved[(64-32)*C4DPL_MEMBERMULTIPLIER-3];
};

////////////////////////////////

#endif //__C4D_OPERATORPLUGIN_H

////////////////////////////////